/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.nickhider.mixins;

import club.sk1er.nickhider.NickHider;
import club.sk1er.nickhider.NickHiderConfig;
import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractClientPlayer.class})
public abstract class AbstractClientPlayerMixin
extends EntityPlayer {
    public AbstractClientPlayerMixin(World worldIn, GameProfile gameProfileIn) {
        super(worldIn, gameProfileIn);
    }

    @Inject(method={"getLocationSkin()Lnet/minecraft/util/ResourceLocation;"}, at={@At(value="HEAD")}, cancellable=true)
    public void nickHider$changePlayerSkin(CallbackInfoReturnable<ResourceLocation> cir) {
        NickHider instance = NickHider.INSTANCE;
        if (instance != null && NickHiderConfig.hidePlayerSkins && NickHiderConfig.masterEnabled) {
            ResourceLocation playerSkin = instance.getPlayerSkin();
            ResourceLocation defaultSkin = DefaultPlayerSkin.func_177334_a((UUID)this.func_110124_au());
            if (this.func_110124_au().equals(Minecraft.func_71410_x().field_71439_g.func_110124_au())) {
                cir.setReturnValue((Object)(NickHiderConfig.realSkin && playerSkin != null ? playerSkin : defaultSkin));
            } else if (NickHiderConfig.skinHiding) {
                cir.setReturnValue((Object)(NickHiderConfig.globalSkin && playerSkin != null ? playerSkin : defaultSkin));
            }
        }
    }

    @Inject(method={"getSkinType"}, at={@At(value="RETURN")}, cancellable=true)
    public void nickHider$changeSkinType(CallbackInfoReturnable<String> type) {
        NickHider instance = NickHider.INSTANCE;
        if (instance != null && NickHiderConfig.hidePlayerSkins && NickHiderConfig.masterEnabled) {
            ResourceLocation playerSkin = instance.getPlayerSkin();
            String playerRealSkinType = instance.getPlayerRealSkinType();
            if (this.func_110124_au().equals(Minecraft.func_71410_x().field_71439_g.func_110124_au())) {
                if (NickHiderConfig.realSkin && playerSkin != null) {
                    type.setReturnValue((Object)playerRealSkinType);
                }
            } else if (NickHiderConfig.skinHiding && NickHiderConfig.globalSkin && playerSkin != null) {
                type.setReturnValue((Object)playerRealSkinType);
            }
        }
    }

    @Inject(method={"getLocationCape"}, at={@At(value="HEAD")}, cancellable=true)
    public void nickHider$changeCape(CallbackInfoReturnable<ResourceLocation> cir) {
        if (cir.getReturnValue() != null) {
            return;
        }
        NickHider instance = NickHider.INSTANCE;
        if (instance != null && NickHiderConfig.hidePlayerSkins && NickHiderConfig.masterEnabled && this.func_110124_au().equals(Minecraft.func_71410_x().field_71439_g.func_110124_au()) && NickHiderConfig.realSkin) {
            cir.setReturnValue((Object)instance.getPlayerCape());
        }
    }
}

